'use client'

import React, { useMemo } from 'react'
import { useParams } from 'next/navigation'
import { produtItems } from '@/lib/contstants'
import { Col, Row, Typography } from 'antd'
import Image from 'next/image'

const ProductPage = () => {
    const {id} = useParams()

    const product = useMemo(() => {
        return produtItems.find(item => item.id === id)
    }, [id])

    return (
        <Col>
            <Row>
                <Typography.Title>
                    {product?.name} - {product?.price} KZT
                </Typography.Title>
            </Row>

            <Row>
                <Image 
                    src={product?.imgSrc || ''} 
                    alt={product?.name || ''}
                    width={600}
                    height={450}
                />
            </Row>
        </Col>
    )
}

export default ProductPage